;
; Disk working set functions (disk.asm)
;
   extern DiskSetCopy         ; copies one working set to another
   extern DiskActivate        ; activates the given disk
   extern DiskSetSetup        ; initializes the disk set
	
;;;*******************************************************************
;;; NAME:	MACRO DiskLineMap()
;;;
;;; DESCR:	Checks out the disk select lines and maps them to the
;;;		the DiskTable offset (DTOFFSET) appropriately.  This
;;;		is in prep for use of DiskTable.  Also sets PCLATH to
;;;		ensure that the DiskTable is mapped correctly.
;;;
;;; ARGS:	(none)
;;;
;;; RETURNS:	sets DTOFFSET appropriately
;;;
;;; NOTES:	- consumes 7 cycles
;;;		- Be sure that nothing between this call and the call
;;;		  to DiskTable changes PCLATH
;;;*******************************************************************
DiskLineMap:	macro
		clrf		DTOFFSET	; (0) prepare for disk mapping
		SkipIfLow	DSELECT_0	; (1) map select lines to table bits
		bsf		DTOFFSET,0	; (2)
		SkipIfLow	DSELECT_1	; (3)
		bsf		DTOFFSET,1	; (4)

		;; now DTOFFSET has the right offset to the DiskTable

		movlw		HIGH DiskTable	; (5) prepare for disk mapping
		movwf		PCLATH		; (6)
                endm
